/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.asm.patch;

import com.charles445.rltweaker.asm.patch.Patch;
import com.charles445.rltweaker.asm.patch.PatchManager;
import com.charles445.rltweaker.asm.util.TransformUtil;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchFixOldHippocampus
extends PatchManager {
    public PatchFixOldHippocampus() {
        super("Old Hippocampus");
        this.add(new Patch(this, "com.github.alexthe666.iceandfire.entity.EntityHippocampus", 1){

            @Override
            public void patch(ClassNode clazzNode) {
                MethodNode m_openGUI = this.findMethod(clazzNode, "openGUI");
                if (m_openGUI == null) {
                    this.cancelled = true;
                    this.announce("Couldn't find openGUI in EntityHippocampus, skipping");
                    return;
                }
                FieldInsnNode anchor = TransformUtil.findNextFieldWithOpcodeAndName(this.first(m_openGUI), 180, "field_72995_K", "isRemote");
                if (anchor == null) {
                    this.cancelled = true;
                    this.announce("Couldn't find isRemote in EntityHippocampus, skipping");
                    return;
                }
                if ((anchor = this.nextInsn((AbstractInsnNode)anchor)) == null) {
                    this.cancelled = true;
                    this.announce("Unexpected end of method in EntityHippocampus, skipping");
                    return;
                }
                if (anchor.getType() != 7) {
                    this.cancelled = true;
                    this.announce("Remote check was not a jump, skipping");
                    return;
                }
                JumpInsnNode remoteJump = (JumpInsnNode)anchor;
                if (remoteJump.getOpcode() != 153) {
                    this.cancelled = true;
                    this.announce("Remote check was server, skipping");
                    return;
                }
                remoteJump.setOpcode(154);
                anchor = TransformUtil.findNextCallWithOpcodeAndName((AbstractInsnNode)remoteJump, 182, "func_184196_w", "isPassenger");
                if (anchor == null) {
                    throw new RuntimeException("Couldn't find func_184196_w or isPassenger in old EntityHippocampus");
                }
                if ((anchor = this.nextInsn((AbstractInsnNode)anchor)) == null) {
                    throw new RuntimeException("Unexpected critical end of method in EntityHippocampus");
                }
                if (anchor.getType() != 7) {
                    throw new RuntimeException("Couldn't find branch after isPassenger in old EntityHippocampus");
                }
                JumpInsnNode passengerJump = (JumpInsnNode)anchor;
                if (passengerJump.getOpcode() != 154) {
                    throw new RuntimeException("Branch for isPassenger is already IFNE in old EntityHippocampus, somehow. Something has gone wrong.");
                }
                passengerJump.setOpcode(153);
            }
        });
    }
}

